// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : |S\vO[ scene.h ]		Auter : KENSUKE WATANABE
//													Data  : 2017/05/11
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2017/05/11
//
// ======== ======== ======== ======== ======== ======== ======== ========
#include "scene.h"
#include "renderer.h"
#include "manager.h"
#include "camera.h"

// -------- -------- -------- -------- -------- -------- -------- --------
// ÓIoϐ
// -------- -------- -------- -------- -------- -------- -------- --------
std::list<CScene*> CScene::m_lisScene[MAX_SCENE_PRIORITY];
int CScene::m_numScene[MAX_SCENE_PRIORITY] = { 0 };			// V[̑

// -------- -------- -------- -------- -------- -------- -------- --------
// vCIeBwRXgN^
// -------- -------- -------- -------- -------- -------- -------- --------
CScene::CScene(int priority = 4) : m_pVtxBuffer(nullptr), m_r(255), m_g(255), m_b(255), m_a(255), m_priority(priority), m_lightOff(false)
{
	//---- Reiɂ߂
	m_lisScene[m_priority].push_back(this);

	//-------- 
	m_objType = OBJTYPE::OBJTYPE_NONE;
	m_pos = D3DXVECTOR3(0.f, 0.f, 0.f);		// W
	m_size = D3DXVECTOR3(0.f, 0.f, 0.f);	// TCY
	m_rot = D3DXVECTOR3(0.f, 0.f, 0.f);		// ]p
	m_scl = D3DXVECTOR3(1.f, 1.f, 1.f);		// g嗦
	m_delete = false;						// tO
	m_numScene[m_priority]++;				// ̃CNg
}
// -------- -------- -------- -------- -------- -------- -------- --------
// fXgN^
// -------- -------- -------- -------- -------- -------- -------- --------
CScene::~CScene()
{
	m_numScene[m_priority]--;		// ̃fNg
}

// ======== ======== ======== ======== ======== ======== ======== ========
// CScene::SXV
// -------- -------- -------- -------- -------- -------- -------- --------
void CScene::UpdateAll(void)
{
	//-------- SXV
	D3DXVECTOR3 camPos = CManager::GetCamera()->GetPos();

	for (int cntPriority = 0; cntPriority < MAX_SCENE_PRIORITY; cntPriority++)
	{
		// XV
		for (CScene* pScene : m_lisScene[cntPriority])
		{
			pScene->Update();
		}

		// J̋ɂă\[g
		m_lisScene[cntPriority].sort([camPos](CScene* pSceneA, CScene* pSceneB)
		{
			D3DXVECTOR3 vecA = camPos - pSceneA->GetPos();
			D3DXVECTOR3 vecB = camPos - pSceneB->GetPos();
			return D3DXVec3LengthSq(&vecA) > D3DXVec3LengthSq(&vecB);
		});

		// 폜tǑĂScene̍폜
		m_lisScene[cntPriority].remove_if([](CScene* pScene)
		{
			bool bErase = false;
			if (pScene->m_delete)
			{
				//---- 
				pScene->Uninit();
				delete pScene;
				pScene = nullptr; 
				bErase = true;
			}
			return bErase;
		});
	}
}

// ======== ======== ======== ======== ======== ======== ======== ========
// CScene::vCIeBwXV
// -------- -------- -------- -------- -------- -------- -------- --------
void CScene::UpdateAll(int priority)
{
	// XV
#pragma omp parallel for
	for (CScene* pScene : m_lisScene[priority])
	{
		pScene->Update();
	}

	// J̋ɂă\[g
	D3DXVECTOR3 camPos = CManager::GetCamera()->GetPos();
	m_lisScene[priority].sort([camPos](CScene* pSceneA, CScene* pSceneB)
	{
		D3DXVECTOR3 vecA = camPos - pSceneA->GetPos();
		D3DXVECTOR3 vecB = camPos - pSceneB->GetPos();
		return D3DXVec3LengthSq(&vecA) > D3DXVec3LengthSq(&vecB);
	});

	// 폜tǑĂScene̍폜
	m_lisScene[priority].remove_if([](CScene* pScene)
	{
		bool bErase = false;
		if (pScene->m_delete)
		{
			//---- 
			pScene->Uninit();
			delete pScene;
			pScene = nullptr;
			bErase = true;
		}
		return bErase;
	});
}

// ======== ======== ======== ======== ======== ======== ======== ========
// CScene::S`
// -------- -------- -------- -------- -------- -------- -------- --------
void CScene::DrawAll(void)
{
	// foCX̎擾
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();

	for (int cntPriority = 0; cntPriority < MAX_SCENE_PRIORITY; cntPriority++)
	{
		for (CScene* pScene : m_lisScene[cntPriority])
		{
			if(pScene->GetLightOff())pDevice->SetRenderState(D3DRS_LIGHTING, FALSE);	// Cg\It
			pScene->Draw();
			if (pScene->GetLightOff())pDevice->SetRenderState(D3DRS_LIGHTING, TRUE);	// Cg̕\Lɂ
		}
	}
}

// ======== ======== ======== ======== ======== ======== ======== ========
// CScene::vCIeBw`
// -------- -------- -------- -------- -------- -------- -------- --------
void CScene::DrawAll(int priority)
{
	// foCX̎擾
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();

#pragma omp parallel for
	for (CScene* pScene : m_lisScene[priority])
	{
		if (pScene->GetLightOff())pDevice->SetRenderState(D3DRS_LIGHTING, FALSE);	// Cg\It
		pScene->Draw();
		if (pScene->GetLightOff())pDevice->SetRenderState(D3DRS_LIGHTING, TRUE);	// Cg̕\Lɂ
	}
}

// ======== ======== ======== ======== ======== ======== ======== ========
// CScene::S[X
// -------- -------- -------- -------- -------- -------- -------- --------
void CScene::ReleaseAll(void)
{
	for (int cntPriority = 0; cntPriority < MAX_SCENE_PRIORITY; cntPriority++)
	{
		// 폜tǑĂScene̍폜
		m_lisScene[cntPriority].remove_if([](CScene* pScene)
		{
			//---- 
			pScene->Uninit();
			delete pScene;
			pScene = nullptr;
			return true;
		});
	}
}

// ======== ======== ======== ======== ======== ======== ======== ========
// CScene::w^CvS[X
// -------- -------- -------- -------- -------- -------- -------- --------
void CScene::TypeRelease(const OBJTYPE &selectObjType)
{
	for (int cntPriority = 0; cntPriority < MAX_SCENE_PRIORITY; cntPriority++)
	{
		// w^CvScene̍폜
		for(CScene* pScene : m_lisScene[cntPriority])
		{
			if (pScene->GetObjType() == selectObjType)
			{
				pScene->Release();
			}
		}
	}
}
